//
//  HNSBasicCompiler.h
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Tue Oct 08 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface HNSBasicCompiler : NSObject {
	// internal lookup
	NSDictionary *keywords;			// reserved keywords
	NSCharacterSet *numerical;		// for numbers
	NSCharacterSet *symbolical;		// for symbols
	NSCharacterSet *whitespace;		// for skipping blanks
	NSCharacterSet *operatorial;	// all characters that may form an operator
	NSDictionary *monops;			// monadic operator/function descriptions
	NSDictionary *binops;			// dyadic operator descriptions
	// source to compile
	NSScanner *source;				// current code scanner position
	unsigned linenumber;			// may be used to show error position
	unsigned linestart;				// start of last line (for getting error lines etc.)
	// method description
	NSMutableDictionary *params;	// call parameter variables - contains [@ref, @type] tuples
	NSDictionary *returnType;		// return type for functions
	NSMutableDictionary *locals;	// local variables
	// nesting context
	NSMutableArray *context;		// nested construct stack of NSStrings - top level is at index 0
	// created code (temporary) storage
	NSMutableString *code;			// created code as HNSCocoaScript
}

// there is only one shared compiler object (in the public interface)

+ (NSDictionary *) keyword:(NSString *) sym;	// get keyword list

+ (NSString *) compile:(NSString *) source;	// compile this code - raise exception on first error

+ (unsigned) linenumber;		// for error processing
+ (unsigned) errorPos;			// scanner position for last error
+ (NSString *) source;			// (re)fetch source
+ (NSDictionary *) params;		// get parameter list
+ (NSDictionary *) returnType;	// get return type
+ (NSString *) code;			// (re)fetch compiled code

@end
